package cn.freemud.management.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.enums.McCafeOperateType;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.adapter.OrderManagerAdapter;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderManagerController
 * @Package cn.freemud.management.controller
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/3/26 16:09
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class OrderManagerController {

    @Autowired
    private OrderManagerAdapter orderManagerAdapter;


    @ApiAnnotation(logMessage = "oms订单履单")
    @ApiOperation(value = "oms订单履单", notes = "订单履单", produces = "application/json")
    @PostMapping("/statusOperate")
    public BaseResponse deliveryCreate(@Validated @LogParams @RequestBody OrderManagerRequest request) {
        OperateType byOpType = OperateType.getByOpType(request.getOperateType());
        if (byOpType==null){
            return ResponseUtil.error(ResponseResult.ORDER_OPERATE_TYPE_NOT_VALIDATE);
        }
        switch (byOpType) {
            case ORDER_CONFIRM:
                return orderManagerAdapter.orderConfirmTake(request);
            case ORDER_DONE:
                return orderManagerAdapter.orderDone(request);
            case ORDER_SEND:
                return orderManagerAdapter.orderDelivery(request);
            case ORDER_AFFIRM:
                return orderManagerAdapter.orderAffirm(request,null);
            case ORDER_REJECT:
                return orderManagerAdapter.orderReject(request);
            case ORDER_AGREE_REFUND:
                return orderManagerAdapter.orderAgreeRefund(request);
            case ORDER_REJECT_REFUND:
                return orderManagerAdapter.orderRejectRefund(request);
            default:
                return ResponseUtil.error(ResponseResult.ORDER_OPERATE_TYPE_NOT_VALIDATE);
        }
    }

    @ApiAnnotation(logMessage = "麦咖啡订单入机")
    @ApiOperation(value = "麦咖啡订单入机", notes = "麦咖啡订单入机", produces = "application/json")
    @PostMapping("/mcCafe/statusOperate")
    public BaseResponse mcCafeDeliveryCreate(@Validated @LogParams @RequestBody OrderManagerRequest request) {
        McCafeOperateType byOpType = McCafeOperateType.getByOpType(request.getOperateType());
        if (byOpType==null){
            return ResponseUtil.error(ResponseResult.ORDER_OPERATE_TYPE_NOT_VALIDATE);
        }
        switch (byOpType) {
            case ORDER_SUCCESS:
                return orderManagerAdapter.orderConfirmTake(request);
            case ORDER_REFUND:
                return orderManagerAdapter.orderReject(request);
            default:
                return ResponseUtil.error(ResponseResult.ORDER_OPERATE_TYPE_NOT_VALIDATE);
        }
    }
}
