package cn.freemud.management.util;

import cn.freemud.management.enums.RedisCacheEnum;

import java.text.MessageFormat;

public class RedisUtil {
    private final static String BASE_URL = "micro_program:";
    private final static String ENTER_SHOP_KEY = BASE_URL + "ENTER_SHOP_KEY_";
    private final static String JOIN_FISSION_ACTIVITIES_KEY = BASE_URL + "JOIN_FISSION_ACTIVITIES_KEY_";
    private final static String COUPON_APP_SECRET = "coupon:app_secret_";

    public static String getEnterShopKey(String userId) {
        return ENTER_SHOP_KEY + userId;
    }

    public static String getJoinFissionActivitiesKey(String userId) {
        return JOIN_FISSION_ACTIVITIES_KEY + userId;
    }

    public static String getCouponAppSecret(String partnerId) {
        return COUPON_APP_SECRET + partnerId;
    }
    
    /**
     * 获取订单支付交易请求序列
     */
    public static String getPaymentTransIdSequenceKey(String orderId) {
       return MessageFormat.format(RedisCacheEnum.PAYMENT_TRANSID_SEQUENCE_KEY.getCode(), orderId);
    }

    /**
     * 获取交易订单key
     */
    public static String getPaymentTransIdOrderKey(String transId){
        return MessageFormat.format(RedisCacheEnum.PAYMENT_TRANSID_ORDER_KEY.getCode(), transId);
    }
}
