package cn.freemud.management.thirdparty;

import cn.freemud.management.annotations.LogIgnoreFeign;
import cn.freemud.management.constant.ResponseCodeConstant;
import cn.freemud.management.constant.ResponseCodeKeyConstant;
import cn.freemud.management.entities.dto.request.delivery.DeliveryOrderAssemblyackRequest;
import cn.freemud.management.entities.dto.request.delivery.DeliveryOrderHaltedRequest;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "DELIVERYCENTER", url = "${delivery.center.feignUrl}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface DeliveryMCCafeClient {

    // 配送停单
    @PostMapping("/delivery/halted")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    DeliveryResponseDto halted(DeliveryOrderHaltedRequest deliveryOrderHaltedRequest);

    /**
     * 、
     * 入机成功通知配送
     */
    @PostMapping("/delivery/assemblyack")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    DeliveryResponseDto assemblyAck(DeliveryOrderAssemblyackRequest request);
}
