package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.delivery.GetFilterPartnerResponse;
import cn.freemud.entities.dto.openplatform.OrderGetPartnerRequest;
import cn.freemud.entities.dto.openplatform.QueryInvoiceConfigRequest;
import cn.freemud.entities.dto.order.OrderInvoiceResponse;
import cn.freemud.entities.vo.SendOrderCountsMsg;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/4/27 下午2:03
 * @description :
 */
@FeignClient(name = "MICRO-OPENPLATFORM")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface MicroOpenplatformClient {

//    /**
//     * 上报微信 有数 统计数据
//     *
//     * @param orderCounts
//     * @return
//     */
//    @LogIgnoreFeign(logMessage="addOrderSum")
//    @PostMapping("/thirdApp/order/addOrderSum")
//    BaseResponse addOrderSum(@RequestBody SendOrderCountsMsg orderCounts);
//
//
//    /**
//     * 获取需要 上报腾讯有数的 商户号
//     *
//     * @return
//     */
//    @LogIgnoreFeign(logMessage="getFilterPartner")
//    @PostMapping("/thirdApp/getFilterPartner")
//    BaseResponse<GetFilterPartnerResponse> getFilterPartner(@RequestBody OrderGetPartnerRequest request);

    /**
     * 获取需要 上报腾讯有数的 商户号
     *
     * @return
     */
    @LogIgnoreFeign(logMessage="orderInvoiceQueryByPartnerId")
    @PostMapping("/order/invoice/config/queryByPartnerId")
    BaseResponse<OrderInvoiceResponse> QueryInvoiceConfigByPartnerId(@RequestBody QueryInvoiceConfigRequest request);

}
