package cn.freemud.service.thirdparty;

import cn.freemud.aop.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "promotion-service", url = "${saas.activityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CalculationClient {
    /**
     * 促销新的算价对接
     */
    @PostMapping("/promotioncenter/calculateservice/discount/sharing")
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    CalculationSharingDiscountResponseDto calculationSharingDiscount(CalculationSharingDiscountRequestDto shareDiscountRequestDto);
}
