package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.enums.OperateClient;
import com.freemud.application.sdk.api.ordercenter.enums.OperateType;
import lombok.Data;

@Data
public class OrderManagerRequest {
    /**
     * 商户号
     */
    private String partnerId;

    /**
     * 门店号
     */
    private String storeId;

    /**
     * 订单号
     */
    private String orderId;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 订单操作类型
     */
    private String operateType;

    /**
     * 操作人
     * pos
     * 开放平台
     * 小助手
     * 系统自动履单
     */
    private String operator;

    private Boolean horseman;
    public OrderManagerRequest(){

    }

    public OrderManagerRequest(String partnerId, String storeId, String orderId, OperateClient operateClient, OperateType operateType){
        this.partnerId=partnerId;
        this.storeId=storeId;
        this.orderId=orderId;
        this.operateType=operateType.getOpType();
        this.operator=operateClient.getOpName();
    }
    public OrderManagerRequest(String partnerId, String storeId, String orderId, OperateClient operateClient, OperateType operateType, String reason){
        this.partnerId=partnerId;
        this.storeId=storeId;
        this.orderId=orderId;
        this.operateType=operateType.getOpType();
        this.operator=operateClient.getOpName();
        this.reason=reason;
        this.horseman = horseman;
    }
    public OrderManagerRequest(String partnerId, String storeId, String orderId, OperateClient operateClient, OperateType operateType,Boolean horseman){
        this.partnerId=partnerId;
        this.storeId=storeId;
        this.orderId=orderId;
        this.operateType=operateType.getOpType();
        this.operator=operateClient.getOpName();
        this.horseman = horseman;
    }
}
