package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CollageOrderRequestVo;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * 拼单订单相关服务特性Service定义
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-27 16:01
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public interface CollageOrderService {
    /**
     * 查询拼单订单
     * @param request
     * @return
     */
    BaseResponse queryCollageOrder(CollageOrderRequestVo request);

    /**
     * 查询拼单状态
     * @param request
     * @return
     */
    BaseResponse queryCollageOrderStatus(CollageOrderRequestVo request);

    /**
     * 创建拼单订单
     * @param request
     * @return
     */
    BaseResponse createCollageOrder(CollageOrderRequestVo request);

    /**
     * 取消拼单订单
     * @param request
     * @return
     */
    BaseResponse cancelCollageOrder(CollageOrderRequestVo request);

    /**
     * 清除拼单订单
     * @param request
     * @return
     */
    BaseResponse clearCollageOrder(CollageOrderRequestVo request);

    /**
     * 更新拼单订单
     * @param request
     * @return
     */
    BaseResponse updateCollageOrder(CollageOrderRequestVo request);

    /**
     * 锁定拼单订单
     * @param request
     * @return
     */
    BaseResponse lockCollageOrder(CollageOrderRequestVo request);

    /**
     * 解锁拼单订单
     * @param request
     * @return
     */
    BaseResponse unlockCollageOrder(CollageOrderRequestVo request);

    /**
     * 拼单参与人加购完毕
     * @param request
     * @return
     */
    BaseResponse readyCollageMemberState(CollageOrderRequestVo request);

    /**
     * 拼单参与人继续加购
     * @param request
     * @return
     */
    BaseResponse shoppingCollageMemberState(CollageOrderRequestVo request);

    /**
     * 加入拼单订单
     * @param request
     * @return
     */
    BaseResponse addCollageOrder(CollageOrderRequestVo request) throws Exception;

    /**
     * 退出拼单订单
     * @param request
     * @return
     */
    BaseResponse outOfOrder(CollageOrderRequestVo request);

    /**
     * 移除拼单人员
     * @param request
     * @return
     */
    BaseResponse removeMember(CollageOrderRequestVo request);
}
