package cn.freemud.entities.vo;

import lombok.Data;

import java.util.HashSet;
import java.util.Set;

/**
 * All rights Reserved; Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponPromotionVO
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/4/18 19:12
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponPromotionVO {
    private String partnerId;
    private String userId;
    private String storeId;
    private String couponCode;
//    private Integer flg;
    //是否查询可用优惠券，根据购物车版本是否为2判断
    private String availableCouponQueryFlag;
    private Integer orderType;
    private String unChooseCouponCode;
    // 用于存放 优惠券数组 兼并老版本的 couponCode
    private Set<String> couponCodes = new HashSet<>();
    // 用于调用会员获取可用 优惠券问题
    private Long deliveryAmount;
    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
        this.couponCodes.add(couponCode);
    }


}
