package com.freemud.application.sdk.api.ordercenter.entities.v1;

import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderPayItemResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.*;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderBeanV1 {

    /**
     * 下单渠道 2:微信小程序  3:支付宝小程序
     */
    private String orderClient;
    /**
     * 订单异常具体描述
     */
    private String abnormalDesc;
    /**
     * 订单异常状态 0:正常（无异常）1:异常
     */
    private Integer abnormalState;

    private Integer bizType;
    /**
     * 是否需要开发票
     */
    private Boolean needInvoice;
    /**
     * 父订单编号
     */
    private String parentCode;
    /**
     * 是否是父订单
     */
    private Boolean isParent;

    /**
     * 第三方交易流水 （微信单号）
     */
    private String thirdPartTradeNo;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 操作时间
     */
    private Long operateTime;
    /**
     * 订单原始金额，单位分
     */
    private BigDecimal originalAmount;
    /**
     * 门店地址
     */
    private String shopAddress;
    /**
     * 收货地址
     */
    private String address;
    /**
     * 收货人名称
     */
    private String contactsName;

    /**
     * 门店电话
     */
    private String shopPhone;

    /**
     * 总金额
     */
    private Long amount;
    /**
     * 用户在界面上看到的支付金额，单位分
     */
    private Long settlementAmount;
    /*
     * 实际支付金额
     */
    private Long actualPayAmount;
    /**
     * 吧台桌号
     */
    private String barCounter;
    /**
     * 取消原因
     */
    private String cancelReason;
    /**
     * 商户ID
     */
    private String companyId;
    private String courierName;
    private String courierPhone;
    private String createUser;
    private String customerOrder;
    private int evaluateStatus;
    private Long gmtAccept;
    private Long gmtDelivery;
    private Long gmtRefundFinish;
    /**
     * 自定义描述字段
     */
    private String extInfo;
    /**
     * 创建时间 时间戳
     */
    private Long gmtCreate;
    /**
     * 期望送达时间
     */
    private Long gmtExpect;
    /**
     * 更新时间 时间戳
     */
    private Long gmtModified;
    private Long gmtPay;
    /**
     * 是否有退款记录
     */
    private Boolean hasRefund;
    private String invoiceInfo;
    /**
     * 维度
     */
    private Double latitude;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 订单ID
     */
    private String oid;
    /**
     * 老版本订单类型  1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
     */
    private Integer orderType;
    /**
     * 新订单服务订单类型
     */
    private Integer newOrderType;
    /**
     * 取餐码
     */
    private String otherCode;
    private String partition;
    private String payChannel;
    private String payChannelType;
    private String payChannelName;
    /**
     * 订单支付状态   1 未支付 2 已支付 3 已退款 4 已经部分退款 5 完成
     */
    private Integer payStatus;
    /**
     * 订单支付类型   1 线上支付 2 货到付款
     */
    private Integer payType;
    /**
     * 支付凭证 非码流水ID
     */
    private String payVoucher;

    /**
     * 手机号  这个老手机号,取 delivery_contact_info 的数据, 历史遗漏问题,其他地方有使用, 不进行改动,
     */
    private String phone;


    /**
     * 下单用户手机号
     */
    private String userMobile;

    private String posId;
    private String remark;
    /**
     * 日订单序号
     */
    private Integer daySeq;
    private String shopId;
    /**
     * 第三方门店
     */
    private String thirdShopId;
    private String shopName;
    private String shopNameEn;
    private String source;
    private String sourceName;
    /**
     * 订单状态  1 下单 2 待支付 3已接单 4 配送中 5 已完成 6 已取消 7 已拒单 31 制作完成
     */
    @Deprecated //不推荐使用，以前业务在使用能改就改，不能改不要动
    private Integer status;

    private Integer statusV2;
    /**
     * 取餐地址
     */
    private String takeAddress;
    /**
     * 取餐排队号  订单详情使用 默认为空
     */
    private String queueIndex;
    /**
     * 预计排队时间，排队人数
     */
    private String returnWords;
    /**
     * 排队进度百分比
     */
    private String progress = "" ; //进度

    /**
     * 是否展示进度条
     */
    private Integer orderProgressBarStatus ;

    /**
     * 是否展示进度条
     */
    private Integer progressBarStatus;
    /**
     * 订单类型   1 外卖 2 预订单 3 商城 4 打包带走 5 店内就餐
     */
//    @Deprecated
//    private Integer type;
    /**
     * 用户ID
     */
    private String userId;

    /**
     * 三方订单编号
     */
    private String thirdOrderCode;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Byte marketingType;

    /**
     * 用户名称
     */
    private String userName;
    private String userType;

    /**
     * 订单操作状态(从订单操作历史表中获取)
     */
    private String operateTakeOrderTime;
    private String operateWaitPayTime;
    private String operateReceiptTime;
    private String operateDistributionTime;
    private String operateCompleteTime;
    private String operateCalcelTime;
    private String operatePefuseTime;
    private String operateCompleteMakeTime;

    /**
     * 运单状态
     */
    private Integer deliverStatus;

    /**
     * 骑手姓名
     */
    private String riderName;
    /**
     * 骑手文案 商家自配送文案
     */
    private String riderText;
    /**
     * 骑手头像 如果是自配送，显示门店首图
     */
    private String riderPhoto;
    /**
     * 门店首图 扩展字段
     */
    private String shopImageUrl;
    /**
     * 骑手电话
     */
    private String riderPhone;
    /**
     * 签收时间 送达时间 收货时间
     */
    private String receiveTime;
    /**
     * 骑手分配时间
     */
    private String depatchTime;
    /**
     * 到店时间
     */
    private String arriveShopTime;
    /**
     * 送出时间
     */
    private String sendTime;
    /**
     * 完成时间
     */
    private String completeTime;

    /**
     * 就餐人数
     */
    private Integer dinersNumber;

    /**
     * 收件人省份
     */
    private String receiveProvince;

    /**
     * 收件人城市
     */
    private String receiveCity;

    /**
     * 收件人区
     */
    private String receiveRegion;

    /**
     * 订单重量
     */
    private BigDecimal weight;

    /**
     * 配送渠道
     */
    private String expressChannelName;

    /**
     * 配送渠道编号
     */
    private String expressChannelCode;

    /**
     * 快递单号
     */
    private String expressNo;


    /**
     * 配送类型 1自配送(三方渠道配送、商家店员配送) 2平台配送
     */
    private Integer expressType;

    /**
     * 签收时间 送达时间 收货时间
     */
    private Long gmtReceiveTime;

    /**
     * 完成时间
     */
    private  Long  gmtCompleteTime;
    /**
     * 下游POS商编号
     */
    private String downstreamPosCode;

    /**
     * 下游订单号
     */
    private String downstreamThirdOrderCode;


    private String pickUpGoodsNo;

    // 预计到达时间
    private Long estimateDeliveryCompleteTime;

    private String appId;

    /**
     *  拼团团号
     */
    private String spellGroupCode;

    /**
     * 拼团活动编号
     */
    private String spellGroupActivityCode;



    private List<AccountBeanV1> accountList;
    private List<ProductBeanV1> productList;
    private List<RefundBeanV1> refundList;
    private AddDeliveryInfoV1 addInfo;

    private List<OperationHistoryV1> orderOperationHistoryList;

    private List<OrderSettlementResp> apportionDetails;

    private List<OrderCostResp> orderCostDetailList;

    private List<OrderSettlementResp> orderSettlementDetailList;

    private List<OrderSendCouponResp> orderSendCouponRespList;

    /**
     * 退款信息
     */
    private AfterSalesOrderResp afterSalesOrderResp;
    /**
     * 发票明细
     */
    private OrderInvoice orderInvoice;

    /**
     * 混合支付list
     */
    private List<OrderPayItemResp> orderPayItem;

    private OrderExtendedReq orderExtended;

}
