package cn.freemud.amp.config;

import com.freemud.application.sdk.api.config.TopicExchangeConfig;
import org.springframework.amqp.core.*;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class DlPayQueryMqConfig {

    /**
     * 消费队列
     */
    public static final String KGD_PAY_QUERY_QUEUE = "kgd_pay_query_queue";
    public static final String KGD_PAY_QUERY_KEY = "kgd_pay_query_key";

    /**
     * 死信队列
     */
    public static final String KGD_PAY_QUERY_DL_QUEUE = "kgd_pay_query_dl_queue";
    public static final String KGD_PAY_QUERY_DL_KEY = "kgd_pay_query_dl_key";



    @Bean("dlPayMqTopicExchange")
    public Exchange dlPaymentMqTopicExchange() {
        return ExchangeBuilder.topicExchange(TopicExchangeConfig.EXCHANGE_NAME).durable(true).build();
    }
    /**
     * 写入RabbitMQ使用的默认队列
     *
     * @return
     */
    @Bean("payQueueName")
    public Queue paymentChangeQueue() {
        return QueueBuilder.durable(KGD_PAY_QUERY_QUEUE).build();
    }

    /**
     * 绑定消息队列
     *
     * @param queue         消息队列
     * @param topicExchange RabbitMQ Fanout Exchange
     * @return 消息队列绑定
     */
    @Bean("bindingPayQueueChange")
    Binding bindingPaymentChange(@Qualifier("payQueueName") Queue queue, @Qualifier("dlPayMqTopicExchange") Exchange topicExchange) {
        return BindingBuilder.bind(queue).to(topicExchange).with(KGD_PAY_QUERY_KEY).noargs();
    }


    @Bean("payChangeDlQueue")
    public Queue paymentChangeDlQueue() {
        Map<String, Object> delayQueueParams = new HashMap<>(2);
        // DLX，dead letter发送到的exchange
        delayQueueParams.put("x-dead-letter-exchange", TopicExchangeConfig.EXCHANGE_NAME);
        // dead letter携带的routing key
        delayQueueParams.put("x-dead-letter-routing-key", KGD_PAY_QUERY_KEY);
        //时间
        //delayQueueParams.put("x-message-ttl", 20*1000);
        return QueueBuilder.durable(KGD_PAY_QUERY_DL_QUEUE).withArguments(delayQueueParams).build();
    }

    @Bean("bindingPayDlChange")
    Binding bindingPaymentDlChange(@Qualifier("payChangeDlQueue") Queue queue, @Qualifier("dlPayMqTopicExchange") Exchange topicExchange) {
        Map<String, Object> args = new HashMap<>(2);
        args.put("x-dead-letter-exchange", TopicExchangeConfig.EXCHANGE_NAME);
        args.put("x-dead-letter-routing-key", KGD_PAY_QUERY_KEY);
        return BindingBuilder.bind(queue).to(topicExchange).with(KGD_PAY_QUERY_DL_KEY).and(args);
    }


}
