package cn.freemud.entities.dto.calculate;

import lombok.Data;

@Data
public class GoodsDiscount {

    /**
     * 活动号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动描述
     */
    private String activityDesc;

    /**
     * 商品ID
     */
    private String goodsId;
    /**
     * 折扣金额
     */
    private Long discount;

    /**
     * 活动类型
     */
    private Integer type;
    /**
     * 当前活动实际优惠的商品数量
     */
    private Integer actualGoodsNumber;

    /**
     * 优惠现单价
     */
    private Long signleDiscount;

    //活动覆盖商品数量，比如第二件实际优惠一件，但是两件商品都算活动叠加数量
    private Integer addOnQuantity = 0;

    /**
     * 当前用户的会员等级(目前只有会员价活动使用)
     */
    private String currentMembershipLevel;

}
