package cn.freemud.entities.dto.calculate;

import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.shoppingCart.SendPoint;
import cn.freemud.entities.vo.SubtractStockVO;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.Set;

@Data
public class CalculationDiscountResult {

    /**
     * 原总价（分）
     */
    private Long originalTotalAmount;
    /**
     * 需支付金额（分）
     */
    private Long totalAmount;
    /**
     * 总优惠金额（分）
     */
    private Long totalDiscountAmount;

    /**
     * 总的优惠信息集合
     */
    private List<Discount> discounts;
    /**
     * 商品优惠信息
     */
    private List<Goods> goods;
    /**
     * 赠送、换购商品信息集合
     */
    private List<SendActivity> sendGoods;
    /**
     * 满额赠券活动号列表
     */
    private List<String> sendCoupons;
    /**
     * 使用到的优惠券及优惠金额
     */
    private List<CouponResults> couponDiscounts;


    /**
     * 多种优惠方案计算出的优惠集合，并按优惠力度倒序排列
     */
//        private List<CalculationResult> calculationResults;

    private List<ApportionGoods> apportionGoods;
    /**
     * 促销活动
     */
    private List<ActivityPrompt> activityPrompts;

    /**
     * 校验后有效的商品券map
     */
    private Map<String, CheckSpqInfoResponseDto> validCouponMap;
    /**
     * 校验后有效的spqid对应的uuid
     */
    private Map<String, List<String>> spqIdToCartUuid;

    /**
     * 扣减库存
     */
    private List<SubtractStockVO> stocks;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 优惠后 配送费
     */
    private Long distributionFee;


    //积分商品活动购物车商品所需总积分")
    private Integer totalScore;

    //用户积分是否足够，1-不够，默认0
    private Integer isScoreLimit = 0;

    private SendPoint sendPointVo;

    /**
     * 麦咖啡，月卡金额
     */
    private Long payCardFee;
    /**
     * 月享卡2.0优惠
     */
    private MonthCardDiscount monthlyEnjoyCardDiscount;

    /**
     * 代金券和折扣券与活动的互斥共享关系(可用优惠券列表使用)
     */
    private Set<ActivityTypeSharedExclusive> couponSharedExclusive;

    //是否是v3版本算价
    private Boolean v3Promotion = false;

}
