package cn.freemud.management.adapter;

import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.takeaway.request.order.*;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: WaimaiSdkAdapter
 * @Package cn.freemud.management.adapter
 * @Description:
 * @author: zhiheng.zhang
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class SaasMallOrderAdapter {

    /**
     * 接单request
     * @param request
     * @param orderBean
     * @return
     */
    public PlatformOrderRequest getPlatformOrderRequest (OrderManagerRequest request, OrderBeanV1 orderBean){
        PlatformOrderRequest platformOrderRequest = new PlatformOrderRequest();
        platformOrderRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        platformOrderRequest.setChannel(orderBean.getSource());
        platformOrderRequest.setCompanyId(orderBean.getCompanyId());
        platformOrderRequest.setOrderId(orderBean.getOid());
        platformOrderRequest.setShopId(orderBean.getShopId());
        platformOrderRequest.setOperator(request.getOperator());
        return platformOrderRequest;
    }

    /**
     * 配送request
     * @param request
     * @param orderBean
     * @return
     */
    public OrderSendOutRequest getOrderSendOutRequest (OrderManagerRequest request, OrderBeanV1 orderBean){
        OrderSendOutRequest orderSendOutRequest = new OrderSendOutRequest();
        orderSendOutRequest.setCompanyId(orderBean.getCompanyId());
        orderSendOutRequest.setOrderId(orderBean.getOid());
        orderSendOutRequest.setShopId(orderBean.getShopId());
        orderSendOutRequest.setOperator(request.getOperator());
        return orderSendOutRequest;
    }

    /**
     * 送达request
     * @param request
     * @param orderBean
     * @return
     */
    public OrderSendOutRequest getOrderArriveRequest (OrderManagerRequest request, OrderBeanV1 orderBean){
        OrderSendOutRequest arriveReq = new OrderSendOutRequest();
        arriveReq.setOrderId(orderBean.getOid());
        arriveReq.setChannel( orderBean.getSource());
        arriveReq.setCompanyId(orderBean.getCompanyId());
        arriveReq.setOperator(request.getOperator());
        arriveReq.setShopId(request.getStoreId());
        return arriveReq;
    }

    /**
     * 拒单
     * @param request
     * @param orderBean
     * @return
     */
    public PartnerCancelRequest getPartnerCancelRequest(OrderManagerRequest request, OrderBeanV1 orderBean){
        PartnerCancelRequest cancelRequest = new PartnerCancelRequest();
        cancelRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        cancelRequest.setOperator(request.getOperator());
        cancelRequest.setType(request.getReason_code() == null ? 11 : request.getReason_code());
        cancelRequest.setReason(request.getReason());
        cancelRequest.setShopId(orderBean.getShopId());
        cancelRequest.setOrderId(request.getOrderId());
        cancelRequest.setChannel(orderBean.getSource());
        cancelRequest.setCompanyId(request.getPartnerId());
        return cancelRequest;
    }


    /**
     * 拒绝或同意退款
     * @param request
     * @param orderBean
     * @param isAgree true:同意退款，false:拒绝退款
     * @return
     */
    public AgreeOrderRequest getAgreeOrderRequest(OrderManagerRequest request, OrderBeanV1 orderBean,boolean isAgree){
        AgreeOrderRequest agreeOrderRequest = new AgreeOrderRequest();
        agreeOrderRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        agreeOrderRequest.setChannel( orderBean.getSource() );
        agreeOrderRequest.setCompanyId(request.getPartnerId());
        agreeOrderRequest.setOrderId(orderBean.getOid());
        agreeOrderRequest.setShopId(orderBean.getShopId());
        agreeOrderRequest.setOperator(request.getOperator());
        agreeOrderRequest.setReason(request.getReason());
        agreeOrderRequest.setAfterSalesCode(orderBean.getRefundList().get(0).getRid());
        agreeOrderRequest.setAgree(isAgree);
        return agreeOrderRequest;
    }

    /**
     * 备餐完成request
     * @param request
     * @param orderBean
     * @return
     */
    public PartnerPrepareRequest getPartnerPrepareRequest (OrderManagerRequest request, OrderBeanV1 orderBean){
        PartnerPrepareRequest partnerPrepareRequest = new PartnerPrepareRequest();
        partnerPrepareRequest.setPlatformOrderId(orderBean.getCustomerOrder());
        partnerPrepareRequest.setChannel(orderBean.getSource());
        partnerPrepareRequest.setCompanyId(orderBean.getCompanyId());
        partnerPrepareRequest.setOrderId(orderBean.getOid());
        partnerPrepareRequest.setShopId(orderBean.getShopId());
        partnerPrepareRequest.setOperator(request.getOperator());
        return partnerPrepareRequest;
    }
}
