/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PromotionActivityClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 11:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.management.thirdparty;


import cn.freemud.management.entities.dto.request.activity.GroupWorkRefundRequest;
import cn.freemud.management.entities.dto.response.activity.GroupWorkRefundResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "promotion-service", url = "${saas.activityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface OMSActivityClient {

    /**
     * 订单主动退款调促销接口
     * @param groupWorkRefundRequest
     * @return
     */
    @PostMapping("/activity/groupWork/refund")
    GroupWorkRefundResponse groupWorkRefund(GroupWorkRefundRequest groupWorkRefundRequest);

}
