package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.vo.TakeMealNoticesVO;
import cn.freemud.utils.ResponseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class CallerService {

    @Autowired
    private RedisTemplate redisTemplate;

    /**
     * 缓存 待制作杯数量
     * @param vo
     */
    private void  cacheTakeMealNotices(TakeMealNoticesVO vo){
        String redisKey = RedisKeyConstant.notMadeGoodsNumber(vo.getPartnerId(), vo.getStoreCode());
        redisTemplate.boundValueOps(redisKey).set(vo.getCupTotalNum(),1, TimeUnit.DAYS);
    }

    public BaseResponse takeMealNotices(TakeMealNoticesVO vo){
        cacheTakeMealNotices(vo);
        //发送取餐通知消息 cc 生态
        return  ResponseUtil.success();
    }

}
