package com.freemud.sdk.api.assortment.shoppingcart.adapter;

import com.freemud.sdk.api.assortment.shoppingcart.constant.CollageOrderCacheFields;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrder;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrderDto;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-27 19:16
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class CollageOrderSdkAdapter {
    public Map<String, String> toRedisMap(CollageOrder collageOrder) {
        Map<String, String> map = new HashMap<>();
        if (!ObjectUtils.isEmpty(collageOrder))
        {
            map.put(CollageOrderCacheFields.COLLAGE_ID.getKey(), String.valueOf(collageOrder.getCollageId()));
            map.put(CollageOrderCacheFields.CREATE_COLLAGE_USER_ID.getKey(), String.valueOf(collageOrder.getCreateCollageUserId()));
            map.put(CollageOrderCacheFields.PARTNER_ID.getKey(), String.valueOf(collageOrder.getPartnerId()));
            map.put(CollageOrderCacheFields.PARTNER_NAME.getKey(), String.valueOf(collageOrder.getPartnerName()));
            map.put(CollageOrderCacheFields.STORE_ID.getKey(), String.valueOf(collageOrder.getStoreId()));
            map.put(CollageOrderCacheFields.STORE_NAME.getKey(), String.valueOf(collageOrder.getStoreName()));
            map.put(CollageOrderCacheFields.CREATE_TIME.getKey(), String.valueOf(collageOrder.getCreateTime()));
            map.put(CollageOrderCacheFields.EXPIRE_TIME.getKey(), String.valueOf(collageOrder.getExpireTime()));
        }
        return map;
    }

    public CollageOrder toCollageOrder(Map<String, String> map) {
        if (CollectionUtils.isEmpty(map)) return null;
        return CollageOrder.builder()
                .collageId(String.valueOf(map.get(CollageOrderCacheFields.COLLAGE_ID.getKey())))
                .createCollageUserId(String.valueOf(map.get(CollageOrderCacheFields.CREATE_COLLAGE_USER_ID.getKey())))
                .partnerId(String.valueOf(map.get(CollageOrderCacheFields.PARTNER_ID.getKey())))
                .partnerName(String.valueOf(map.get(CollageOrderCacheFields.PARTNER_NAME.getKey())))
                .storeId(String.valueOf(map.get(CollageOrderCacheFields.STORE_ID.getKey())))
                .storeName(String.valueOf(map.get(CollageOrderCacheFields.STORE_NAME.getKey())))
                .createTime(Long.parseLong(map.get(CollageOrderCacheFields.CREATE_TIME.getKey())))
                .expireTime(Long.parseLong(map.get(CollageOrderCacheFields.EXPIRE_TIME.getKey())))
                .build();
    }

    public CollageOrder toCollageOrder(CollageOrderDto collageOrderDto) {
        return CollageOrder.builder()
                .collageId(collageOrderDto.getCollageId())
                .partnerId(collageOrderDto.getPartnerId())
                .partnerName(collageOrderDto.getPartnerName())
                .storeId(collageOrderDto.getStoreId())
                .storeName(collageOrderDto.getStoreName())
                .createCollageUserId(collageOrderDto.getCreateCollageUserId())
                .build();
    }
}
