package cn.freemud.management.handler;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.thirdparty.FMAssistantApplicationClient;
import cn.freemud.management.thirdparty.request.OrderSellCouponRefundRequest;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.MarketTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.util.LogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/4/21 10:55
 * @description : 小助手额外 业务逻辑操作
 */
@Component
public class AssisantApplicationHandler {

    // 搞个线程池, 不影响主体业务

    @Autowired
    private FMAssistantApplicationClient fmAssistantApplicationClient;

    @Autowired
    private LogUtil logUtil;

    /**
     * 抖音直播卖券的订单核销 退单操作
     *
     * @param orderCode     订单号  必须满足下列条件  才能调用接口
     * @param bizType       com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum#ORDINARY
     * @param orderClient   com.freemud.application.sdk.api.ordercenter.enums.OrderClientType#ASSISTANT
     * @param marketingType com.freemud.application.sdk.api.ordercenter.enums.MarketTypeEnum#TIKTOK_MARKET_ORDER
     */
    public void assisantThirdPartyOrderRefundHandler(String orderCode, Integer bizType, String orderClient, Byte marketingType) {
        boolean isSend = Objects.equals(bizType, BizTypeEnum.ORDINARY.getBizType()) &&
                Objects.equals(orderClient, OrderClientType.ASSISTANT.getIndex()) &&
                Objects.equals(marketingType, MarketTypeEnum.TIKTOK_MARKET_ORDER.getIndex());
        if (isSend) {
            OrderSellCouponRefundRequest req = new OrderSellCouponRefundRequest();
            req.setOrderCode(orderCode);
            try {
                fmAssistantApplicationClient.orderRefund(req);
            } catch (Exception e) {
                logUtil.error("", "通知小助手取消抖音核销券订单失败", e, JSON.toJSONString(req));
            }
        }
    }
}
