package cn.freemud.service.adapter;

import cn.freemud.entities.bo.CreateOrderBONew;
import cn.freemud.entities.dto.store.StoreMixResponseDto;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.interceptor.ServiceException;

/**
 * 订单检查
 */
public interface OrderCheck {

    /***
     * 是否匹配
     * @param orderType {@link CreateOrderType}
     * @return
     */
    boolean support(int orderType);

    /**
     * 检查
     * @param vo
     * @param storeMixResponseDto
     */
    void check(CreateOrderVo vo, StoreMixResponseDto storeMixResponseDto) throws ServiceException;

    void check(CreateOrderBONew vo) throws ServiceException;

}
