package cn.freemud.util;

import cn.freemud.base.util.DateUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import java.util.Date;
import java.util.Locale;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: Rfc3339Util
 * @Package cn.freemud.utils
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2019/3/13 16:11
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class Rfc3339Util {

    public static final String FORMAT_YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";

    public static long parseRFC3339(String datestr) {
        long result = 0;
        try {
            DateTime dateTime = new DateTime(datestr);
            result = dateTime.toCalendar(Locale.getDefault()).getTimeInMillis();
        } catch (Exception e) {

        }
        return result;
    }

    public static String getRFC3339(long time) {
        String result = "";
        try {
            DateTime dt = new DateTime(time, DateTimeZone.UTC);
            result = dt.toString();
        } catch (Exception e) {

        }
        return result;
    }

    public static String strToRfc3339(String date) {
        long time = DateUtil.convert2Date(date, FORMAT_YYYY_MM_DD_HHMMSS).getTime();
        return getRFC3339(time);
    }

    public static String dateToRfc3339(Date date) {
        return getRFC3339(date.getTime());
    }
}
