package cn.freemud.service.impl;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 * 集点活动
 *
 * @version V1.0
 * @Title: BuyAndGiftsPromotionService
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/16
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("gatherSpotPromotionService")
public class GatherSpotPromotionService implements IPromotionService {

    /**
     * 集点活动只有赠送的点数，没有优惠金额<br/>
     * 优惠金额不做处理
     * @param couponPromotionVO
     * @param activityQueryDto
     * @param calculationDiscountResult
     * @param cartGoodsList
     * @param shoppingCartGoodsResponseVo
     * @param userLoginInfoDto
     * @param shoppingCartInfoRequestVo
     */
    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto,
                                                ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult,
                                                List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo,

                                                UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        return;
    }

    /**
     * 活动类型-TYPE_221筛选出集点活动
     * 集点活动没有优惠金额，所以促销金额设置为0
     * @param shoppingCartGoodsResponseVo
     * @param calculationDiscountResult
     * @param shoppingCartGoodsDto
     * @param premiumExchangeActivity
     * @param shoppingCartInfoRequestVo
     */
    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getDiscounts())) {
            return;
        }

        // 活动类型-TYPE_221筛选出集点活动
        List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.Discount> gatherSpots = calculationDiscountResult.getDiscounts().stream().filter(activityPrompt -> null != activityPrompt.getType() && ActivityTypeEnum.TYPE_221.getCode().intValue() == activityPrompt.getType().intValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(gatherSpots)) {
            return;
        }

        // 其他活动已经计算出来的促销活动
        List<ActivityDiscountsDto> activityDiscountsDtos = shoppingCartGoodsDto.getActivityDiscountsDtos() == null ? new ArrayList<>() : shoppingCartGoodsDto.getActivityDiscountsDtos();

        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.Discount  gatherSpot : gatherSpots) {
            //设置优惠活动
            ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
            activityDiscountsDto.setActivityCode(gatherSpot.getActivityCode());
            activityDiscountsDto.setActivityName(gatherSpot.getActivityName());
            activityDiscountsDto.setActivityType(gatherSpot.getType());
            activityDiscountsDto.setDiscountAmount(0);
            activityDiscountsDtos.add(activityDiscountsDto);
        }

        shoppingCartGoodsDto.setActivityDiscountsDtos(activityDiscountsDtos);
    }

}
