package cn.freemud.fuyou.controller.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
public class BaseRequest {

    @NotEmpty(message = "thirdOrderCode 不能为空")
    private String thirdOrderCode;

    @NotEmpty(message = "用户id不能为空")
    private String userId;

    @NotEmpty(message = "posCode不能为空")
    private String posCode;

    @NotEmpty(message = "商户id不能为空")
    private String partnerId;

    @NotEmpty(message = "门店id不能为空")
    private String storeId;

    /**
     * 支付渠道
     * 1. 微信，2.支付宝，3.现金 4.svc，5.积分,6优惠券
     */
    @NotNull(message = "支付渠道不能为空")
    private Integer payChannel;
    /**
     * 支付金额  单位:分
     */
    @NotNull(message = "支付金额不能为空")
    private Long payAmount;
    /***
     * 支付码，微信，支付宝，svc
     */
    private String code;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 商品信息
     */
    private List<OrderItemCreateReq> orderItemList;
    /***
     * 扩展字段
     * 支付流水号 ，用来查询支付信息,支付接口返回的无需入参
     */
    private String fmId;
    /**
     * 下单渠道
     * * 1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS
     */
    @NotNull(message = "orderClient 不能为空")
    private String orderClient;
    /**
     *  根据 thirdOrderCode 查询的数据
     */
    private OrderInfoReqs orderInfoReqs;


}
