package cn.freemud.service;

import cn.freemud.demo.entities.bo.goods.GetProductBySkuIdResponseBO;
import cn.freemud.entities.dto.product.info.ProductBean;
import cn.freemud.entities.vo.GetProductsVo;

import java.util.List;
import java.util.Map;

/**
 * 商品服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public interface ItemService {





    boolean hasAttributeAll(List<String> attributeIds, ProductBean productBean);

    /**
     * 通过sku或单品组装MAP商品详情信息
     * @param pids skuId
     * @param partnerId
     * @param storeId
     * @return key = skuid
     */
    Map<String, GetProductsVo> getProducts(List<String> pids, String partnerId, String storeId ,String menuType);


    /**
     * 通过sku或单品组装MAP商品详情信息
     * @param pids skuId
     * @param partnerId
     * @param storeId
     * @return key = skuid
     */
    Map<String, GetProductBySkuIdResponseBO> getProductsBySkuId(List<String> pids, String partnerId, String storeId , String menuType);

}
