package cn.freemud.entities.dto.delivery;

import cn.freemud.base.util.DateUtil;
import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: CallbackUrlRequestDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/12 14:53
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@Data
public class MacCafeCallbackUrlRequestDto {
    /**
     * 订单编号
     */
    private String orderId;
    /**
     * 运单编号
     */
    private String deliveryId;
    /**
     * 蜂鸟第三方订单号
     */
    private String channelDeliveryId;
    /**
     * 订单状态枚举值
     */
    private int deliveryStatus;
    /**
     * 骑手联系方式
     */
    private String riderPhone;
    /**
     * 骑手名称
     */
    private String riderName;
    /**
     * 描述
     */
    private String remark;
    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 门店号
     */
    private String storeId;
    /**
     * 渠道名称
     */
    private String channelName;
    /**
     * 渠道短码
     */
    private String channelCode;

    /**
     * 更新时间
     */
    private String updateTime = DateUtil.getCurrentDate(DateUtil.FORMAT_YYYY_MM_DD_HHMMSS);

    /**
     * 麦咖啡取消运单审核状态
     * 1:同意取消  2:拒绝取消
     */
    private Integer reviewStatus;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 退款发起方，0用户 1餐道
     */
    private Integer cancelApplicant;
}
