package cn.freemud.entities.coupon;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.entities.vo.coupon CouponStateVo
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/6/30
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponStateVo {

    /**
     * 券号
     */
    private String couponCode;

    private Integer type;
    /**
     * 状态
     * 0 可用  1 不可用  2 限制可用
     */
    private Integer state;
    /**
     * 不可用原因
     */
    private String message;
    /**
     * 最小金额 分
     */
    private Integer minAmount;
    /**
     * 数量
     */
    private Integer amount;
    /**
     * 活动折扣价格 分
     */
    private Integer priceDiscount;
    /**
     * 原价 分
     */
    private Integer originalPrice;
    /**
     * 折扣百分比
     */
    private Integer discount;
    /**
     * 限制类型
     * 0 白名单 1 黑名单
     */
    private String limitType;
    /**
     * 今日剩余可使用次数(频次券才包含)
     */
    private Integer dailyAvailableTimes;

    /**
     * 总可使用次数(频次券才包含)
     */
    private Integer availableTimes;

    /**
     * 可用商品
     */
    private List<Product> productList;

}
