/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderConditionsReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/3 20:07
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.List;

@Data
public class OrderConditionsReq {

    //订单CODE")
    private String orderCode;

    //订单CODE集合")
    private List<String> orderCodes;

    //用户ID")
    private String userId;

    //用户姓名")
    private String userName;

    //收货人电话")
    private String mobile;

    //配送方式 1自配送(三方渠道配送、商家店员配送) 2平台配送
    private Byte expressType;

    //配送状态大类 1:待派单 2:已派单 3:配送中 4:待配送
    private Integer dispenseStatus;

    //商品编码
    private String productId;

    //商品名称
    private String productName;

    //商户编号
    private String partnerId;

    //门店编号
    private List<String> storeIds;

    //第三方编号
    private String thirdOrderCode;

    //订单状态
    private Integer orderStatus;

    //订单完成或订单进行中，不填写表示全部
    private Boolean finishStatus;

    //订单类型
    private List<Integer> orderTypes;

    //订单支付类型
    private List<Integer> payTypes;

    //订单支付状态
    private List<Integer> payStatuses;

    //售后单（退款）状态
    private Integer afterSalesStatus;

    //订单来源/下单渠道
    private List<Integer> orderClients;

    //订单创建开始时间戳（单位：秒）
    private Long startTimestamp;

    //订单创建结束时间戳（单位：秒）
    private Long endTimestamp;

    //订单更新开始时间戳（单位：秒）
    private Long startUpdateTimestamp;

    //订单更新结束时间戳（单位：秒）
    private Long endUpdateTimestamp;

    //是否打印 0:显示打印次数为0 1:显示打印次数大于0
    private Byte printNum;

    //是否挂起状态 0:正常 1:挂起
    private Byte suspendState;

    //分页大小
    private Integer pageSize;

    //当前分页
    private Integer pageNum;

    //批量订单状态
    private List<Integer> orderStatuses;

    //订单业务类型 1:普通订单 2:虚拟订单
    private Integer bizType;

    private List<Integer> bizTypes;

    // 外部对象ID 如:活动ID
    private List<String> externalObjectIds;
    // 外部对象ID 如:活动类型
    private List<Integer> settlementTypes;
    //异常单状态
    private List<Integer> abnormalStatuses;

    //应用ID
    private String appId;
    //是否删除
    private Integer isDeleted;
    //营销活动类型
    private Integer marketingType;
    //es查询排序规则 0=倒序， 1= 正序
    private int sortRule;
}
