package cn.freemud.entities.vo.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;


@Data
public class CreateOrderInvoiceRequest {

    @ApiModelProperty("会话Id")
    @NotEmpty(message = "会话Id不能为空")
    private String sessionId;

    @ApiModelProperty("商户号")
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    @ApiModelProperty("订单编号")
    @NotNull(message = "订单编号不能为空")
    @Size(max = 30,message = "单张发票限制30个订单，超过限额不能开票")
    private List<String> orderCodes;

    @ApiModelProperty(value = "开票人")
    @NotEmpty(message = "开票人不能为空")
    private String drawer;

    @ApiModelProperty(value = "开票金额，单位:分")
    @NotNull(message = "开票金额不能为空")
    private Long totalActualPayAmount;
}
