package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: UpdateDeliveryInfoByIdRequestDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/13 16:10
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@Data
public class UpdateDeliveryInfoByIdRequest extends BaseConfig {

    /**
     * 运单号
     */
    private String deliveryId;
    /**
     * 订单id必须是数字
     */
    private String orderId;
    /**
     * 配送员姓名
     */
    private String courierName;
    /**
     * 配送员电话
     */
    private String courierPhone;
    /**
     * 快递公司编号
     */
    private String express;
    //配送渠道名称
    private String expressChannelName;
    /**
     * 快递单号
     */
    private String expressNo;
    /**
     * 配送渠道编号
     */
    private String expressChannelCode;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 下单渠道
     * 1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS
     */
    private Integer orderClient;
    /**
     * 状态变更明细
     */
    private String remark;
    /**
     * 第三方订单号
     */
    private String thirdOrderCode;
    /**
     * 新订单状态
     */
    private Integer orderSubState;

    /**
     * 配送平台统一异常Id
     */
    private Integer exceptionId;
    /**
     * 配送平台统一异常描述
     */
    private String exceptionDesc;

    /**
     * 操作类型 0 = 发货 1=更改物流信息
     */
    private int opType;

    private OrderTaskReq orderTask;

}
