package com.freemud.application.sdk.api.ordercenter.enums;

/**
 * 状态码
 *
 * @author liming.guo
 * @date 2018/05/10
 */
public enum ResponseResultEnum {
    /**
     * 通用信息返回
     */
    SUCCESS("100", "ok"),
    SYSTEM_ERROR("50001", "系统内部异常"),
    WECHAT_SYSTEM_ERROR("50003", "微信系统繁忙"),
    SYSTEM_BUSINESS_ERROR("50002", "调用子服务异常"),
    NOT_LOGIN("40001", "token已过期，请重新登录"),
    PARAMETER_MISSING("40002", "参数不正确"),
    USER_PERMISSION_DENIED("40003", "用户权限不足，无法操作"),

    /**
     * 订单
     */
    ORDER_DATA_NOT_FOUND("54001", "查询订单数据失败"),
    ORDER_DATA_NOT_EXIST("54002", "没有相关数据"),
    ORDER_STORE_NOT_FOUND("54003", "门店ID或门店名称不存在"),

    ;
    private String code;
    private String message;


    /**
     * @param code    状态码
     * @param message 提示信息
     */
    ResponseResultEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
