package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ActivitySprint
 * @Package cn.freemud.enums
 * @Description: 简单描述下这个类是做什么用的
 * @author: biao.zhang
 * @date: 2018/12/9 17:58
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum ActivityTypeEnum {
    TYPE_1(1, "整单满减"),
    TYPE_11(11, "每满减"),
    TYPE_12(12, "阶梯满减"),
    TYPE_230(230, "满赠"),
    TYPE_13(13, "新用户立减"),
    TYPE_14(14, "满额减配送费"),
    TYPE_104(104,"x件y折"),

    /**
     * 限时特价
     */
    TYPE_2(2, "单品特价"),
    TYPE_21(21, "单品折扣"),
    TYPE_22(22, "单品立减"),
    TYPE_23(23, "超值加购"),
    /**
     * 优惠券
     */
    TYPE_3(3, "代金券"),
    TYPE_31(31, "折扣券"),
    TYPE_32(32, "商品券"),
    TYPE_33(33, "换购券"),
    TYPE_37(37, "月享卡种子券"),
    TYPE_5(5, "整单满金额折"),
    TYPE_51(51, "每满金额折"),
    TYPE_52(52, "阶梯满金额折"),
    TYPE_53(53, "第M件/杯N折"),
    TYPE_6(6, "买M赠N"),
    TYPE_61(61, "单品买M赠N"),
    TYPE_62(62, "买赠"),
    TYPE_63(63, "买一赠一寄杯"),
    TYPE_7(7, "满额赠券"),
    TYPE_8(8, "满N件换购"),
    /**
     * 加价购
     */
    TYPE_81(81, "满额换购"),
    TYPE_82(82, "满额阶梯换购（满多少金额，加价换购）"),
    TYPE_100(100, "阶梯满数量打折"),
    TYPE_101(101, "整单满数量打折"),
    TYPE_102(102, "阶梯单品满数量打折"),
    TYPE_103(103, "阶梯单品满数量减N元"),
    TYPE_200(200, "X元Y件"),
    TYPE_PACKAGE(900, "包装费"),
    TYPE_DELIVERY(901, "配送费"),
    TYPE_310(310, "套餐活动优惠"),
    TYPE_320(320, "会员价商品优惠"),
    TYPE_221(221, "集点");

    private Integer code;

    private String desc;

    ActivityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
