package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.goods.ListCartGoodsRequestDTO;
import cn.freemud.demo.entities.bo.goods.ManagerServiceBO;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.list.PlatformListCartGoodsBO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.manager.coupon.CouponService;
import cn.freemud.demo.manager.customer.CustomerService;
import cn.freemud.demo.manager.product.ProductService;
import cn.freemud.demo.manager.promotion.PromotionService;
import cn.freemud.demo.manager.store.StoreService;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ListCartGoodsBOAdapter {

    @Autowired
    @Qualifier("KgdCustomerService")
    private CustomerService kgdCustomerServIce;

    @Autowired
    @Qualifier("KgdProductService")
    private ProductService kgdProductService;

    @Autowired
    @Qualifier("KgdStoreService")
    private StoreService kgdStoreService;

    @Autowired
    @Qualifier("KgdPromotionService")
    private PromotionService kgdPromotionService;

    @Autowired
    @Qualifier("KgdCouponService")
    private CouponService kgdCouponService;

    @Resource
    private MapperFacade mapperFacade;

    public ListCartGoodsBO convert2ListCartGoodsBO(String bizType, ListCartGoodsRequestDTO baseRequestDTO) {

        ListCartGoodsBO updateAddGoodsBO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            updateAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            updateAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return updateAddGoodsBO;

    }

    private ListCartGoodsBO createPlatformBO(ListCartGoodsRequestDTO baseRequestDTO) {


        PlatformListCartGoodsBO platformListCartGoodsBO = BeanUtil.convertBean(baseRequestDTO, PlatformListCartGoodsBO::new);
        // CartGoods platformProductBO = convert2PlatformProductBO(baseRequestDTO);
        // platformAddGoodsBO.setAddGoods(platformProductBO);

        ManagerServiceBO managerService = ManagerServiceBO.builder()
                .customerService(kgdCustomerServIce)
                .productService(kgdProductService)
                .couponService(kgdCouponService)
                .storeService(kgdStoreService)
                .promotionService(kgdPromotionService)
                .build();
        platformListCartGoodsBO.setManagerService(managerService);

        return platformListCartGoodsBO;

    }

    private ListCartGoodsBO createMCoffeeBO(ListCartGoodsRequestDTO baseRequestDTO) {
        return null;
    }

}
