/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductInfoDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 19:52
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class GetValidateProductInfoDto {

    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 根据spu或者sku查询所有商品信息
     */
    private List<String> productIds;
    /**
     * 查询指定spu下面的制定sku信息
     */
    private List<ProductInfo> productInfoList;

    /**
     * 门店商品渠道 saas(开个店自提)、saasdelivery（开个店外卖）、saasmall（微商城）、wc（围餐）、mtwm（美团外卖）、jdwm（京东外卖）、fmwd（非码微店）、eleme（饿了么外卖）、ebwm（饿百外卖）
     */
    private String channel;

    /**
     * 业务类型 7-预定单  爱马哥蛋糕预定场景使用(2.0.41迭代 1032929)
     */
    private Integer bizType;

    @Data
    public static class ProductInfo {
        /**
         * 商品spu
         */
        private String spuId;
        /**
         * 商品sku
         */
        private List<String> skuIds;
    }
}
