/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StockClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 1.5.4对接库存服务
 * @author: ping.wu
 * @date: 2019/2/20 14:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import com.freemud.sdk.api.assortment.order.request.stock.UpdateProductStockRequestDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "ims-service",url = "${saas.productstockclient.feign.url:}")
@RequestMapping(value = "/inv",produces = {"application/json;charset=UTF-8"})
public interface StockClient {


    /**
     * 扣减库存
     */
    @PostMapping("/reduceStocks")
    BaseResponse reducesStocks(@RequestBody UpdateProductStockRequestDto requestDto);


}
