package cn.freemud.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @description:
 * @author: chengfeixiang<feixiang.cheng @ freemud.cn>
 * @date: 2022/1/25 15:03
 * @version: v1.0
 * @copyright: 2022 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Getter
@AllArgsConstructor
public enum OrderConfigEnum {

    CART_LIMIT_TYPE("cartLimitType","kgd:open_store_cart_limit_", "购物车限制"),
    EAT_IN("eatInType", "kgd:order_refund_config_","订单退款配置（堂食）"),
    TAKE_OUT("takeOutType", "kgd:order_refund_config_","订单退款配置（外卖）"),
    CASHIER_TYPE("cashierType", "kgd:order_refund_config_", "订单退款配置（收银）"),
    REFUND_COMPLAINT("orderComplaintType", "kgd:order_config_", "订单申诉配置"),
    PACK_AMOUNT_TYPE("packAmountType", "kgd:order_pack_config_","餐盒费收费规则配置"),
    ;


    private String type;

    private String key;

    private String message;

    public static OrderConfigEnum getOrderConfigType (String type) {
        OrderConfigEnum[] values = OrderConfigEnum.values();
        for (OrderConfigEnum orderConfigEnum : values) {
            if (orderConfigEnum.getType().equals(type)) {
                return orderConfigEnum;
            }
        }
        return null;
    }

}
