package cn.freemud.enums;

import java.util.Arrays;

public enum BusinessTypeEnum {
    SAAS_PICKUP(0,"saas","saas"),
    SAAS_DELIVERY(1,"saasdelivery","saasdelivery"),
    SAAS_MALL(2,"saasmall","saasmall"),
    SAAS_WC(3,"wc","wc");


    private Integer type;
    private String name;
    private String code;

    BusinessTypeEnum(Integer type, String name, String code) {
        this.type = type;
        this.name = name;
        this.code = code;
    }

    public static BusinessTypeEnum getByType(Integer type) {
        return Arrays.stream(BusinessTypeEnum.values())
                .filter(e -> e.type.equals(type))
                .findFirst().orElse(BusinessTypeEnum.SAAS_PICKUP);
    }

    public static BusinessTypeEnum getByType(String type) {
        return Arrays.stream(BusinessTypeEnum.values())
                .filter(e -> e.name.equals(type))
                .findFirst().orElse(BusinessTypeEnum.SAAS_PICKUP);
    }

    public static String getByCode(String code){
        return  Arrays.stream(BusinessTypeEnum.values())
                .filter(e -> e.code.equals(code))
                .findFirst().orElse(BusinessTypeEnum.SAAS_PICKUP).getCode();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
