package cn.freemud.controller;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.vo.CollageOrderRequestVo;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-28 11:53
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CollageOrderControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    @Test
    public void queryCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("c05bf8184c7e7783be35c7fb1d4d04d4f03b3b6f")
                .partnerId("1864")
                .shopId("520916")
                .build();

        try {
            mockMvc.perform(post("/shoppingCart/collage/getOrder").content(JSONObject.toJSONString(request)).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void createCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("c05bf8184c7e7783be35c7fb1d4d04d4f03b3b6f")
                .partnerId("1864")
                .shopId("520916")
                .build();

        try {
            mockMvc.perform(post("/shoppingCart/collage/createOrder").content(JSONObject.toJSONString(request)).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void cancelCollageOrder() {
        CollageOrderRequestVo request = CollageOrderRequestVo.builder()
                .sessionId("c05bf8184c7e7783be35c7fb1d4d04d4f03b3b6f")
                .partnerId("1864")
                .shopId("520916")
                .build();

        try {
            mockMvc.perform(post("/shoppingCart/collage/cancelOrder").content(JSONObject.toJSONString(request)).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
