package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.order.FacePayRequestDto;
import cn.freemud.entities.dto.order.UnifiedPayResponseDto;
import cn.freemud.entities.dto.order.InvoiceCreateResponse;
import cn.freemud.entities.dto.pay.InvoiceCreateRequest;
import cn.freemud.entities.dto.pay.UnifiedOrderRequestDto;
import cn.freemud.entities.dto.order.RefundQueryResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PaymentNewClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: ping1.wu
 * @date: 2019/12/25 19:09
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@FeignClient(name = "payment-center-api",url="${payment.new.baseUrl:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PaymentNewClient {

    // TODO: 21-4-1 待合并

    /**
     * 扫脸支付
     */
    @LogIgnoreFeign(logMessage="facePay",statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("paymentcenter/facePay")
    com.freemud.application.sdk.api.base.BaseResponse<UnifiedPayResponseDto> facePay(@RequestBody FacePayRequestDto orderPayDto);


    /**
     * 创建预支付订单，唤起支付
     */
    @LogIgnoreFeign(logMessage="unifiedOrder",statusCodeFieldName= ResponseCodeKeyConstant.CODE)
    @PostMapping("paymentcenter/unifiedOrder")
    com.freemud.application.sdk.api.base.BaseResponse<UnifiedPayResponseDto> unifiedOrder(@RequestBody UnifiedOrderRequestDto requestDto);

    @LogIgnoreFeign(logMessage="refundQuery")
    @PostMapping("paymentcenter/refundQuery")
    com.freemud.application.sdk.api.base.BaseResponse<RefundQueryResponseDto> refundQuery(@RequestBody FacePayRequestDto orderPayDto);


    /**
     * 开订单发票
     */
    @LogIgnoreFeign(logMessage="paymentcenter/invoice/create",statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("paymentcenter/invoice/create")
    com.freemud.application.sdk.api.base.BaseResponse<InvoiceCreateResponse> createInvoice(@RequestBody InvoiceCreateRequest request);

    //线下付，储值卡/礼品卡支付
    @LogIgnoreFeign(logMessage="codePay",statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping("paymentcenter/codePay")
    com.freemud.application.sdk.api.base.BaseResponse<UnifiedPayResponseDto> codePay(@RequestBody FacePayRequestDto orderPayDto);


}
