package com.freemud.sdk.api.assortment.order.service;

import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.request.OrderModifyRelatingCodeReq;
import com.freemud.application.sdk.api.ordercenter.request.QueryAfterSalesOrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.request.QueryLineUpOrderReq;
import com.freemud.application.sdk.api.ordercenter.response.AfterSalesListResp;
//import com.freemud.application.sdk.api.ordercenter.response.OrderStateInfoResp;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.*;

public interface OrderCenterSdkService {

    /**
     * 创建订单
     *
     * @return
     */
    @Deprecated
    CreateOrderResponse createOrderFlow(CreateOrderRequest createOrderRequest);

    /**
     * 创建父子订单
     */
    @Deprecated
    CreateFatherSonOrderResponse createFatherSonOrder(CreateFatherSonOrderRequest createFatherSonOrderRequest);

    CreateOrderResponse createOrder(BaseCreateOrderRequest baseCreateOrderRequest);

    /**
     * 订单支付确认 C端
     */
    @Deprecated
    PayAccessResponse payAccess(ConfirmOrderRequest confirmOrderRequest);

    /**
     * 订单支付确认 麦咖啡
     */
    PayAccessResponse payAccessMCCafe(ConfirmOrderRequest confirmOrderRequest);

    /**
     * 根据订单编号查询订单信息 C端
     */
    QueryOrderByIdResponse queryOrderById(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 条件查询订单列表 C端
     */
    QueryOrdersResponse queryOrders(QueryOrdersRequest queryOrdersRequest);

    /**
     * 野翠山发票订单列表查询
     */
    QueryOrdersResponse queryOrdersNew(QueryOrdersRequest queryOrdersRequest);

    /**
     * 根据订单编号查询订单信息 C端
     */
    QueryOrderByIdResponse queryMCCafeOrderById(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 条件查询订单列表 C端
     */
    QueryOrdersResponse queryMCCafeOrders(QueryOrdersRequest queryOrdersRequest);

    /**
     * 删除订单 C端
     */
    BaseOrderResponse deleteOrder(DeleteOrderRequest deleteOrderRequest);

    /**
     * 订单申请退款 C端
     */
    BaseOrderResponse orderRefund(OrderRefundRequest orderRefundRequest);

    /**
     * 编辑订单 C端
     */
    BaseOrderResponse orderEdit(OrderEditRequest orderEditRequest);

    /**
     * 订单取消 C端，POS
     */
    BaseOrderResponse orderCancel(CancelOrderRequest cancelOrderRequest);

    /**
     * 获取取餐排队号  C端
     */
    BaseOrderResponse queryOrderQueueIndex(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 获取当前门店接单数 C端
     */
    BaseOrderResponse queryStoreOrderQuantity(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 根据订单ID查询订单状态操作记录 C端
     */
    OrderStatusTrackingInfoResponse getOrderStatusTrackingInfoByOid(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 轮询订单 POS
     */
    QueryOrdersResponse repeatGetOrders(RepeatQueryOrdersRequest repeatQueryOrdersRequest);

    /**
     * 订单确认接单 POS
     */
    BaseOrderResponse orderConfirmTake(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单确认接单 POS
     */
    BaseOrderResponse orderConfirmTakeMCCafe(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单POS拒单 POS
     */
    BaseOrderResponse orderReject(CancelOrderRequest cancelOrderRequest);

    /**
     * 订单POS拒单 POS
     */
    BaseOrderResponse mcCafeOrderReject(CancelOrderRequest cancelOrderRequest, OrderBeanV1 orderBean);

    /**
     * 订单配送中 POS
     */
    BaseOrderResponse orderSend(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单确认送达 POS
     */
    BaseOrderResponse orderAffirm(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单同意并退款完成 POS
     */
    BaseOrderResponse refundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单退款完成 POS
     */
    BaseOrderResponse orderRefundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单同意并退货完成 POS
     */
    BaseOrderResponse refundReturn(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 订单拒绝退款 POS
     */
    BaseOrderResponse orderRefundReject(CancelOrderRequest cancelOrderRequest);

    /**
     * 自提订单制作完成 POS
     */
    BaseOrderResponse orderDone(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 条件查询门店订单 POS
     */
    QueryOrdersResponse getOrderListByConditions(QueryOrdersByConditionsRequest queryOrdersByConditionsRequest);

    /**
     * 条件查询门店订单
     */
    QueryOrdersResponse getOrderListByES(QueryOrdersByConditionsRequest queryOrdersByConditionsRequest);

    /**
     * 批量查询订单（供POS拉单使用）
     *
     * @param request
     * @return
     */
    BatchQueryResponse batchQuery(BatchQueryRequest request);

    /**
     * 统计每日营业额
     *
     * @param request
     * @return
     */
    GetStatisticStoreOrderReportResponse getStatisticStoreOrderReport(GetStatisticStoreOrderReportRequest request);

    /**
     * 根据订单ID修改第三方配送信息
     *
     * @param request
     * @return
     */
    OrderBaseResponse updateDeliveryInfoById(UpdateDeliveryInfoByIdRequest request);

    /**
     * 综合条件查询订单
     *
     * @param request
     * @return
     */
    OrderDownloadResponse orderDownload(OrderDownloadRequest request);

    /**
     * 根据订单ID查询订单详情(B端后台用)
     *
     * @param request
     * @return
     */
    @Deprecated
    OrderDetailResponse getByIdForParentProduct(BaseQueryOrderRequest request);

    /**
     * 查询售后单列表
     *
     * @param request
     * @return
     */
    QueryRefundOrderResponse queryAfterSalesList(QueryRefundOrdersRequest request);

    /**
     * POS拉售后单
     *
     * @param request
     * @return
     */
    BatchQueryAfterSalesResponse batchQueryAfterSales(BatchQueryAfterSalesRequest request);

    /**
     * 批量查询订单状态
     *
     * @param request
     * @return
     */
    BatchOrdersStateResponse batchQueryOrderStatus(BatchOrdersStateRequest request);

    /**
     * 批量查询订单明细
     *
     * @param request
     * @return
     */
    QueryOrdersResponse batchQueryByCodes(BatchQueryByCodesRequest request);

    /**
     * 查询父子订单
     *
     * @param request
     * @return
     */
    QueryRelatedOrderByCodeResp queryRelatedOrderByCode(QueryRelatedOrderByCodeRequest request);

    /**
     * 修改第三方订单号
     *
     * @param assortmentSdkUpdateThirdOrderCodeRequest
     * @return
     */
    BaseOrderResponse updateThirdOrderCode(AssortmentSdkUpdateThirdOrderCodeRequest assortmentSdkUpdateThirdOrderCodeRequest);

    /**
     * 更新三方配送单异常
     */
    OrderBaseResponse updateDeliveryAbnormal(AssortmentUpdateDeliveryAbnormalRequest request);

    /**
     * 围餐创建订单
     */
    CreateOrderResponse createGroupOrder(AssortmentGroupCreateOrderRequest createOrderRequest);

    /**
     * 围餐订单完成
     */
    AssortmentAffirmGroupOrderResponse affirmGroupOrder(AssortmentGroupOrderAffirmRequest orderAffirmRequest);

    /**
     * 修改订单(围餐)
     */
    OrderDetailResponse updateGroupOrder(AssortmentGroupUpdateOrderRequest createOrderRequest);

    /**
     * 清空订单商品
     */
    AssortmentAffirmGroupOrderResponse clearGroupOrder(AssortmentGroupOrderClearRequest groupOrderClearRequest);

    /**
     * 修改订单商品信息
     *
     * @param updateOrderProductInfoRequest
     * @return
     */
    OrderDetailResponse updateOrderItem(AssortmentSdkUpdateOrderProductInfoRequest updateOrderProductInfoRequest);

    /**
     * 清台
     *
     * @param clearTableRequest
     * @return
     */
    OrderBaseResponse clearTableNumber(ClearTableRequest clearTableRequest);

    /**
     * 获取订单加菜
     *
     * @param orderCommonRequest
     * @return
     */
    AssortmentOrderGetOrderAddProductResponse getOrderAddProduct(OrderCommonRequest orderCommonRequest);

    /**
     * 分页查询售后单(es)
     */
    AfterSalesListResp queryAfterSalesListES(QueryAfterSalesOrderConditionsReq queryRequest, String trackNo);

    /**
     * 查询售后单详情(es)
     * @param orderCode
     * @param partnerId
     * @param trackNo
     * @return
     */
    QueryOrderByIdResponse queryOrderByCodeES(String orderCode, String partnerId, String trackNo);


    /**
     * 根据用户ID 查询30分钟内未支付并且有券的 订单
     *
     * @param userId              用户ID
     * @param trackingNo           交易号
     * @return
     */
    QueryOrdersResponse queryOrderWithCoupon(String userId, String trackingNo);


    /**
     * 根据下游POS信息查询订单
     * @param downstreamPosCode
     * @param downstreamThirdOrderCode
     * @param trackingNo
     * @return
     */
    QueryOrderByIdResponse queryOrderByDownstream(String downstreamPosCode, String downstreamThirdOrderCode, String trackingNo);


    /**
     * 订单更新下游POS信息
     * @param assortmentSdkUpdateDownstreamThirdOrderCodeRequest
     * @return
     */
    BaseOrderResponse updateDownstreamThirdOrderCode(AssortmentSdkUpdateDownstreamThirdOrderCodeRequest assortmentSdkUpdateDownstreamThirdOrderCodeRequest);

    /**
     * 修改桌号、取餐码
     * @param orderModifyRelatingCodeReq
     * @return
     */
    BaseOrderResponse updatePickUpGoodNo(OrderModifyRelatingCodeReq orderModifyRelatingCodeReq, String trackingNo);

    /**
     * 查询商户每个门店未退款的订单数量<br/>
     * @param request
     * @return
     */
    QueryPartnerRefundCountResponse queryRefundCount(QueryStoreRefundCountRequest request);

    /**
     * 获取历史订单
     */
    QueryLineUpResponse queryLineUpOrder(QueryLineUpOrderReq queryLineUpOrderReq);

    /**
     * 商城订单同意并退款完成 POS
     */
    BaseOrderResponse mallOrderRefundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 商城订单同意并退款完成 POS
     */
    BaseOrderResponse adultApproveWithRefundComplete(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 商城订单同意并退货完成 POS
     */
    BaseOrderResponse mallOrderRefundReturn(BaseQueryOrderRequest baseQueryOrderRequest);


    /**
     * 商城订单同意退款申请
     */
    BaseOrderResponse mallOrderAgreeApply(BaseQueryOrderRequest baseQueryOrderRequest);

    /**
     * 用户修改订单快递信息
     * @param afterSalesExpressRequest
     * @return
     */
    BaseOrderResponse editAfterSalesExpress(EditAfterSalesExpressRequest afterSalesExpressRequest);

    /**
     * 订单拒绝退款 POS
     */
    BaseOrderResponse mallOrderRefundReject(CancelOrderRequest cancelOrderRequest);


    /**
     * 根据订单编号查询订单状态信息
     */
    OrderStateInfoResp queryOrderStateInfo(String orderCode, String partnerId, Byte orderClient, String trackNo);


    /**
     * 订单POS拒单 POS
     */
    BaseOrderResponse mallOrderReject(CancelOrderRequest cancelOrderRequest);

    /**
     * 分页查询售后单(从库查询)
     */
    AfterSalesListResp queryAfterSalesListFromDb(QueryAfterSalesOrderConditionsReq queryRequest, String trackNo);
    /**
     * 小助手日结统计订单信息查询（分页，从库查询）
     */
    QueryOrdersResponse getOrderListByDb(QueryOrdersByConditionsRequest queryOrdersByConditionsRequest);
}
