package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: EventResDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/27 18:54
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class EventResDto {
    private String id;
    private String cg; //类别id
    private String cgCN; //类别名称
    private String name;
    private String props;//todo
    private String beforeId;  // 切换前门店号
    private String beforeName; //切换前门店名称
    private String afterId; // 切换后门店号
    private String afterName; // 切后前门店名称
    private String result;//支付结果返回: 成功, 取消
    private List<ProductsVo> products;
    @Data
    public static class ProductsVo{
        private String id; //商品id
        private String name;// 商品名称
        private String cg; // 类别id
        private String cgCN;// 类别名称
        private List<Props> props;//属性，"key": "温度","val": "去冰"
        @Data
        public static class Props{
            private String key;
            private String val;
        }
    }
}
