/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartNewServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/23 16:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.ShoppingCartMealServiceImpl;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.shoppingcart.constant.MealClearOperationEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartMealServiceTest {

    @Autowired
    private ShoppingCartMealServiceImpl shoppingCartBaseService;
    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    @Test
    public void t1() {
        shoppingCartMCoffeeService.availableCoupon(JSON.parseObject("{\"appId\":\"2021001186684481\",\"channelType\":\"saas\",\"menuType\":\"saasdelivery\",\"orderType\":2,\"partnerId\":\"1206\",\"sessionId\":\"05d9eca513ad391f02e589838cd3089b6154c2ba\",\"shopId\":\"1450026\"}", ShoppingCartInfoRequestVo.class));
    }

    @Test
    public void t2() {
        shoppingCartMCoffeeService.getShoppingCartGoods(JSON.parseObject("{\"shoppingCartInfoRequestVo\":{\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"reachStoreType\":5,\"receiveId\":\"\",\"sessionId\":\"eac51b0d36095d85659f2c89b49e5623ff9e4f1e\",\"shopId\":\"1450026\"}}", GetShoppingCartGoodsApportionRequestVo.class));
    }

    @Test
    public void addGoods() {
        add("testMealDE");
    }

    private void add(String sessionId) {
        String requestJson = "{\"appId\":\"wxb78fb7c6218cb52c\",\"categoryName\":\"库存\",\"orderType\":1,\"partnerId\":\"1864\",\"productComboList\":[],\"productGroupList\":[],\"sessionId\":\"testMealDE\",\"shopId\":\"2700968\",\"skuId\":\"\",\"spuId\":\"152577617791293208\"}";
        AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo = JSONObject.parseObject(requestJson, AddShoppingCartGoodsRequestVo.class);
        addShoppingCartGoodsRequestVo.setSessionId(sessionId);
        long startTime = System.currentTimeMillis();
        BaseResponse response = shoppingCartBaseService.addGoods(addShoppingCartGoodsRequestVo);
        log.info("addGoods consumeTime:{} response:{}", System.currentTimeMillis() - startTime, JSONObject.toJSONString(response));
    }

    @Test
    public void updateGoodsQty() {
        String requestJson = "{\n" +
                "    \"appId\":\"wxaf1b67249de514a3\",\n" +
                "    \"cartGoodsUid\":\"cab52def-ca89-4edd-9f2e-a1618a355873\",\n" +
                "    \"orderType\":1,\n" +
                "    \"partnerId\":\"1864\",\n" +
                "    \"qty\":3,\n" +
                "    \"sessionId\":\"unitTestMealW\",\n" +
                "    \"version\":\"1.5.2\",\n" +
                "    \"carVer\":1\n" +
                "}";
        UpdateShoppingCartGoodsQtyRequestVo requestVo = JSONObject.parseObject(requestJson, UpdateShoppingCartGoodsQtyRequestVo.class);
        BaseResponse response = shoppingCartBaseService.updateGoodsQty(requestVo);
        log.info("updateGoodsQty response:{}", JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());
    }

    @Test
    public void listCartGoodsTest() {
        BaseResponse response = listCartGoods();
        log.info("listCartGoods  response:{}", JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());

    }

    private BaseResponse<ShoppingCartGoodsMealResponseVo> listCartGoods() {
        String requestJson = "{\"activityCode\":\"\",\"appId\":\"wxb78fb7c6218cb52c\",\"couponCode\":\"\",\"orderType\":1,\"partnerId\":\"1864\",\"sendGoods\":[],\"sessionId\":\"testMealDE\",\"shopId\":\"2700968\",\"useCustomerScore\":2}";
        ShoppingCartInfoRequestVo requestVo = JSONObject.parseObject(requestJson, ShoppingCartInfoRequestVo.class);
        return shoppingCartBaseService.getGoodsList(requestVo);
    }

    @Test
    public void getShoppingCartGoodsTest() {
        String requestJson = "{\n" +
                "        \"flag\":0,\n" +
                "        \"orderType\":1,\n" +
                "        \"partnerId\":\"1864\",\n" +
                "        \"reachStoreType\":5,\n" +
                "        \"sessionId\":\"unitTestMeal2\",\n" +
                "        \"shopId\":\"666666\",\n" +
                "        \"carVer\":4\n" +
                "    }";
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = JSONObject.parseObject(requestJson, ShoppingCartInfoRequestVo.class);
        CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity = new CreateOrderVo.PremiumExchangeActivity();
        BaseResponse<ShoppingCartGoodsDto> response = this.shoppingCartBaseService.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity);
        log.info("getShoppingCart response:{}", JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());
    }


    public void toOrder(Integer carVer) {
        String requestJson = "{\n" +
                "        \"flag\":0,\n" +
                "        \"orderType\":1,\n" +
                "        \"partnerId\":\"1864\",\n" +
                "        \"reachStoreType\":5,\n" +
                "        \"sessionId\":\"unitTestMeal2\",\n" +
                "        \"shopId\":\"666666\",\n" +
                "        \"carVer\":4\n" +
                "    }";
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = JSONObject.parseObject(requestJson, ShoppingCartInfoRequestVo.class);
        shoppingCartInfoRequestVo.setCarVer(carVer);
        long startTime = System.currentTimeMillis();
        CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity = new CreateOrderVo.PremiumExchangeActivity();
        BaseResponse<ShoppingCartGoodsDto> response = this.shoppingCartBaseService.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity);
        log.info("getShoppingCart consumeTime:{} response:{}", System.currentTimeMillis() - startTime, JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        //下单成功清除购物车
        this.clearLockShoppingCartTest();
        //查询购物车
        this.listCartGoods();
    }

    @Test
    public void clearLockShoppingCartTest() {
        clearShoppingCart(MealClearOperationEnum.CLEAR_LOCK);
    }

    @Test
    public void recoverLockTest() {
        clearShoppingCart(MealClearOperationEnum.RECOVER);
    }

    @Test
    public void clearAllTest() {
        clearShoppingCart(MealClearOperationEnum.CLEAR_ALL);
    }

    private void clearShoppingCart(MealClearOperationEnum operationEnum) {
        long startTime = System.currentTimeMillis();
        ShoppingCartClearRequestVo requestVo = new ShoppingCartClearRequestVo();
        requestVo.setPartnerId("1864");
        requestVo.setSessionId("unitTestMeal2");
        requestVo.setOperationType(operationEnum.getOperationType());
        BaseResponse response = this.shoppingCartBaseService.clear(requestVo);
        log.info("clear consumeTime:{} operationType:{} response:{}", System.currentTimeMillis() - startTime, operationEnum.getOperationType(), JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());
    }

    @Test
    public void autoAllTest() {
        //加入购物车
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 1; i <= 3; i++) {
            final int index = i;
            executorService.execute(() -> {
                add("unitTestMeal" + index);
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        //查询购物车
        long startTime = System.currentTimeMillis();
        BaseResponse<ShoppingCartGoodsMealResponseVo> response = listCartGoods();
        log.info("listCartGoods consumeTime:{} response:{}", System.currentTimeMillis() - startTime, JSONObject.toJSONString(response));
        Assert.assertNotNull(response);
        Assert.assertEquals(ResponseResult.SUCCESS.getCode(), response.getCode());
        Integer carVer = response.getResult().getCarVer();
        //下单，清除下单成功的
        toOrder(carVer);
        //再次查询购物车
        response = listCartGoods();
        log.info("toOrder listCartGoods  consumeTime:{} response:{}", System.currentTimeMillis() - startTime, JSONObject.toJSONString(response));
        //清台
        this.clearAllTest();
        log.info("查询、下单、清空 consumeTime:{}", System.currentTimeMillis() - startTime);
    }

}
