package cn.freemud.fuyou.service.processor;

import cn.freemud.base.util.DateUtil;
import cn.freemud.enums.PayChannelEnum;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.PaymentService;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.OrderSettlementType;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderSettlementReq;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.application.sdk.api.paymentcenter.client.request.CodePayRequest;
import com.freemud.application.sdk.api.paymentcenter.client.response.CodePayResponse;
import com.freemud.application.sdk.api.paymentcenter.client.service.PaymentNewService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * svc优惠处理
 */
@Component
@Slf4j
public class SvcEventProcessor extends AbstractProcessor {
    private final PaymentNewService paymentNewService;

    protected SvcEventProcessor(OrderSdkService orderSdkService, PaymentService paymentService,
                                PaymentNewService paymentNewService) {
        super(orderSdkService, paymentService);
        this.paymentNewService = paymentNewService;
    }


    @Override
    BaseResponse doProcess(DiscountRequest request)
    {
        BaseResponse baseResponse =new BaseResponse();
        baseResponse.setCode(ResponseResultEnum.SUCCESS.getCode());
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());

        CodePayRequest codePayRequest =new CodePayRequest();
        codePayRequest.setCode(request.getCode());
        codePayRequest.setAmount(request.getPayAmount());
        codePayRequest.setStoreId(orderInfoReqs.getStoreId());
        codePayRequest.setFrontTransId(orderInfoReqs.getOrderCode());
        codePayRequest.setProducts(convertPayProduct(request.getOrderItemList()));
        codePayRequest.setBody(orderInfoReqs.getStoreName());
        codePayRequest.setBusinessDate(DateUtil.convert2String(new Date(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        codePayRequest.setStationId("1");
        codePayRequest.setOperatorId("1");
        codePayRequest.setVer("2");
        //codePayRequest.setCode("10102");
        codePayRequest.setPartnerId(orderInfoReqs.getPartnerId());
        codePayRequest.setTransId(orderInfoReqs.getOrderCode());

        final com.freemud.application.sdk.api.base.BaseResponse<CodePayResponse> codePayResponseBaseResponse = paymentNewService.codePay(codePayRequest, LogThreadLocal.getTrackingNo());
        log.info("SVC.paymentFeignClient.codePay,request:{},response:{}", JSON.toJSONString(codePayRequest),JSON.toJSONString(codePayResponseBaseResponse));
        if(ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getCode()) ||
                ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getData().getCode()) ||
                ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getData().getData().getResultCode())
        ){
            baseResponse.setCode(codePayResponseBaseResponse.getCode());
            baseResponse.setMessage(codePayResponseBaseResponse.getMessage());
            return baseResponse;
        }
        request.setFmId(codePayResponseBaseResponse.getData().getData().getFmId());
        return baseResponse;
    }

    @Override
    OrderSettlementReq getOrderSettlement(DiscountRequest request) {
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());
        return buildOrderSettlement("SVV支付", OrderSettlementType.SVC, true, orderInfoReqs, request);
    }

    @Override
    public Integer getEvent() {
        return PayChannelEnum.SVC.getCode();
    }
}
