package cn.freemud.handler;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.dto.openplatform.PushOrderStoreDto;
import cn.freemud.entities.dto.openplatform.ReportStoreIdsRequestVo;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.thirdparty.StoreBackstageClient;
import cn.freemud.utils.LogUtil;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/5/10 下午4:18
 * @description : 【ID1027442】 下单门店记录并每天推送门店
 * 第二天凌晨4点 报上 上一天的门店支付情况
 * 使用 TLS 接口形式  定时访问
 */
@Component
public class OrderReportJobHandler {

    private static final String pattern_yyyy_MM_dd = "yyyy-MM-dd";
    //private static final String pattern_yyyyMMdd = "yyyyMMdd";

    @Autowired
    private RedisCache redisCache;

    @Autowired
    private StoreBackstageClient storeBackstageClient;

    public void sendYesterDayStoreMsg() {
        String date = getYesterdayString(pattern_yyyy_MM_dd);
        BoundHashOperations<String, String, Set<String>> boundHashOperations = redisCache.getRedisTemplate().boundHashOps(RedisKeyConstant.KGD_NO_ORDER_STORE_DATE + date);
        Map<String, Set<String>> entries = boundHashOperations.entries();
        LogUtil.info("下单门店记录推送 entries", entries, null);
        if (!CollectionUtils.isEmpty(entries)) {
            // 推送门店 服务
            List<ReportStoreIdsRequestVo> requestDto = new ArrayList<>(entries.size());
            entries.forEach((partnerId, storeIds) -> {
                ReportStoreIdsRequestVo build = ReportStoreIdsRequestVo.builder().partnerId(partnerId).storeCodeList(storeIds).build();
                requestDto.add(build);
            });
            try {
                // 发送服务
                PushOrderStoreDto pushOrderStoreDto = PushOrderStoreDto.builder().pushDate(getYesterdayString(pattern_yyyy_MM_dd))
                        .partnerList(requestDto)
                        .build();
                BaseResponse baseResponse = storeBackstageClient.pushOrderStore(pushOrderStoreDto);
                LogUtil.info("上报门店支付情况", JSON.toJSONString(pushOrderStoreDto), JSON.toJSONString(baseResponse));
                // fisherman 数据推送之后的 redis 缓存数据 是否清理 暂时没需求
            } catch (Exception e) {
                LogUtil.error("上报门店支付情况 error", null, JSON.toJSONString(e));
            }
        }
    }


    /**
     * 需要获取 昨天的 yyyy-MM-dd
     *
     * @return
     */
    private String getYesterdayString(String pattern) {
        Calendar start = Calendar.getInstance();
        // 取昨天时间
        start.add(5, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);//注意月份是MM
        return simpleDateFormat.format(start.getTime());
    }

}
