package cn.freemud.demoTest.service.factory;

import cn.freemud.base.ApplicationContextWare;
import cn.freemud.demoTest.enums.PartnerIdEnum;
import cn.freemud.demoTest.enums.TradeBizTypeEnum;
import cn.freemud.demoTest.service.*;

public class ServiceFactory {

    public static AbstractTradeService createTradeInstance(String bizType) {
        AbstractTradeService abstractTradeService = null;
        if (TradeBizTypeEnum.PLATFORM.getCode().equals(bizType)) {
            abstractTradeService = ApplicationContextWare.getBean(PlatformPaySuccessService.class);
        } else if (TradeBizTypeEnum.MEALS.getCode().equals(bizType)){
            abstractTradeService =  ApplicationContextWare.getBean(MEALSService.class);
        }else if (TradeBizTypeEnum.MAIL.getCode().equals(bizType)){
            abstractTradeService =  ApplicationContextWare.getBean(MAILService.class);
        }
        return abstractTradeService;
    }



    public static AbstractPaySuccessService createPaySuccessInstance(String parnterId) {
        AbstractPaySuccessService abstractPaySuccessService = null;
        if (PartnerIdEnum.MC_cofe.getPartnerId().equals(parnterId)) {
            abstractPaySuccessService = ApplicationContextWare.getBean(McCofePaySuccessService.class);
        } else if (PartnerIdEnum.COCO.getPartnerId().equals(parnterId)){
            abstractPaySuccessService =  ApplicationContextWare.getBean(COCOPaySuccessService.class);
        }
        return abstractPaySuccessService;
    }

}
