/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberInfoResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/5 17:26
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.List;

@NoArgsConstructor
@Data
@ToString
public class GetMemberInfoByChannelResponseDto {

    /**
     * code : 100
     * message :
     * result : {"account":"","birthday":"","channelList":[{"cardCode":"","cardTemplateId":"","channelCode":"dcxcx","channelType":"1","customerCardCode":"","registerCode":"","registerType":"2","thirdPartyCode":"ob0iP4nIyQrS9Ye-vgKOlsc2QGm8","unionId":""}],"city":"","district":"","email":"","idCard":"","memberId":"115282009388979639","memberName":"","mobile":"14170070313","nickName":"tommy风","partnerId":"360bb48b-5316-458a-903e-9a44c7f339b1","photoUrl":"","province":"","regionCode":"","remark1":"","sexFlag":"","sonBirthday":"","weddingDay":"","wifeBirthday":""}
     * ver : 1
     */

    private String code;
    private String message;
    private ResultBean data;
    private String ver;

    @NoArgsConstructor
    @Data
    public static class ResultBean {
        /**
         * birthday :
         * channelList : [{"cardCode":"","cardTemplateId":"","channelCode":"dcxcx","channelType":"1","customerCardCode":"","registerCode":"","registerType":"2","thirdPartyCode":"ob0iP4nIyQrS9Ye-vgKOlsc2QGm8","unionId":""}]
         * city :
         * district :
         * email :
         * idCard :
         * memberId : 115282009388979639
         * memberName :
         * mobile : 14170070313
         * nickName : tommy风
         * partnerId : 360bb48b-5316-458a-903e-9a44c7f339b1
         * photoUrl :
         * province :
         * regionCode :
         * remark1 :
         * sexFlag :
         * sonBirthday :
         * weddingDay :
         * wifeBirthday :
         */
        /**
         * 会员编号
         */
        private String memberId;
        /**
         * 会员名称
         */
        private String memberName;
        /**
         * 昵称
         */
        private String nickName;
        /**
         * 手机号
         */
        private String mobile;
        /**
         * 头像地址
         */
        private String photoUrl;
        /**
         * 性别{0未知1男2女}
         */
        private String sexFlag;
        /**
         * 生日
         */
        private String birthday;
        /**
         * 邮箱
         */
        private String email;
        /**
         * 身份证
         */
        private String idCard;
        /**
         * 注册时间{格式：yyyy-MM-dd HH:mm:ss}
         */
        private String registerTime;
        /**
         * 会员渠道列表
         */
        private List<ChannelListBean> memberChannels;

        @NoArgsConstructor
        @Data
        public static class ChannelListBean {
            /**
             * cardCode :
             * cardTemplateId :
             * channelCode : xcx
             * channelType : 1
             * customerCardCode :
             * registerCode :
             * registerType : 2
             * thirdPartyCode : ob0iP4nIyQrS9Ye-vgKOlsc2QGm8
             * unionId :
             */
            /**
             * 卡号{原生卡卡号}
             */
            private String cardCode;
            /**
             * 原生卡ID{微信原生卡ID、支付宝模板ID、商户自定义原生卡ID}
             */
            private String cardId;
            private String cardTemplateId;
            /**
             * 渠道编码{xcx:会员小程序,dcxcx:点餐小程序,ptxcx:拼团小程序}
             */
            private String channelCode;
            /**
             * 渠道Id
             */
            private String channelId;
            /**
             * 创建时间
             */
            private String createTime;
            /**
             * 会员编号
             */
            private String memberId;
            /**
             * 商户编号
             */
            private String partnerId;
            /**
             * 注册门店
             */
            private String registerStoreCode;
            /**
             * 注册类型
             */
            private String registerType;
            /**
             * Openid
             */
            private String thirdPartyCode;
            /**
             * unionId
             */
            private String unionId;

            /**
             * 更新时间
             */
            private String updateTime;
        }
    }
}
