package cn.freemud.client;

import cn.freemud.entities.dto.GetMemberCouponListRequestDto;
import cn.freemud.entities.dto.GetMemberCouponListResponseDto;
import cn.freemud.service.thirdparty.CustomerExtendClient;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class CustomerExtendClientTest {
    @Autowired
    private CustomerExtendClient customerExtendClient;
    @Test
    public void getUserInfo() {
        GetMemberCouponListRequestDto requestDto=new GetMemberCouponListRequestDto("1864","115417276085674268");
        requestDto.setPageNum(1);
        requestDto.setPageSize(10);
        requestDto.setStatusFlags(new ArrayList<>(0));
        requestDto.setIsProduct(1);
        requestDto.setCouponType(0);
        GetMemberCouponListResponseDto responseDto=customerExtendClient.getMemberCouponListRequestDto(requestDto);
    }
}
