/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: EnterShopActivityResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/10/12 15:40
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.openplatform.AddWeixinCardCodeResponseDto;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class EnterShopActivityResponseVo {

    private  String activityName;
    private List<CouponInfo> coupons;
    /**
     * 加入微信卡包参数 v1.5.4新增
     */
    private List<AddWeixinCardCodeResponseDto.WeixinCardCodeList> cardCodeList;

    @NoArgsConstructor
    @Data
    public static class CouponInfo {
        /**
         * 优惠券类型 0-商品券 1-代金券 2-折扣券
         */
        private Integer couponType;
        /**
         * 活动code v1.5.4新增
         */
        private String activityCode;
        /**
         * 券码
         */
        private String couponCode;
        /**
         * 券名称
         */
        private String couponName;
        /**
         * 过期时间
         */
        private String expiryTime;
        /**
         * 抵扣金额
         */
        private Integer discountAmount;
        private String validityPeriodEnd;
        private String validityPeriodStart;
        /**
         * 有效期 2019.01.12-2019.02.12
         */
        private String effectiveData;
    }
}
