package cn.freemud.entities.dto;


import lombok.Data;

import java.util.List;

@Data
public class GetMemberInfoResponseVo {

    private String userId;

    private Score score;

    private List<Coupon> coupons;

    private List<Card> cards;

    @Data
    public static class Score {

        /**
         * 当前可用积分
         */
        private Integer currentScore;
        /**
         * 积分抵扣金额，单位分
         */
        private Integer reduceAmount;

        /**
         * 抵扣积分
         */
        private Integer reduceScore;

    }

    @Data
    public static class Coupon {

        /**
         * 券名称
         */
        private String couponName;

        /**
         * 券CODE
         */
        private String couponCode;

        /**
         * 券类型 0：商品 券 1：代金券 3 折扣券
         */
        private Integer cuoponType;

        /**
         * 如：2019-10-1 至 2019-10-10 当天有效
         */
        private String couponLimit;

        /**
         * 优惠金额,单位分
         */
        private Integer discountAmount;

        /**
         * 状态：-1:未激活 0:可用(剔除过期) 1:已使用 2:部分使用 3:取消 6:已过期(根据生失效日期) 99：未知（目前暂不支持）
         */
        private Integer status;

        private List<Product> products;

    }

    @Data
    public static class Product {

        /**
         * 商户商品编号
         */
        private String pid;

        /**
         * 商品名称
         */
        private String name;

        /**
         * 最大可取商品个数
         */
        private Integer number;

        /**
         * 商品折扣价，以分为单位
         */
        private Integer priceAct;

        /**
         * 原价，以分为单位
         */
        private Integer priceOriginal;

        /**
         * 支付信息
         */
        Payment payment;

    }

    @Data
    public static class Payment {

        /**
         * 线上已付金额，以分为单位
         */
        private Integer paid;

        /**
         * 线下需要收取的金额，以分为单位
         */
        private Integer remaining;

    }

    @Data
    public static class Card {

        /**
         * 实充余额，单位分
         */
        private Integer amount;

        /**
         * 赠送余额，单位分
         */
        private Integer vamount;

        /**
         * 卡规格ID
         */
        private String applyId;

        /**
         * 卡号
         */
        private String cardCode;

        /**
         * 卡名称
         */
        private String cardName;

    }
}
