package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrder;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrderDto;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.CollageCartBaseServiceImpl;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.CollageOrderBaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-28 09:34
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableAutoConfiguration
public class CollageOrderBaseServiceTest {
    @Autowired
    private CollageOrderBaseServiceImpl collageOrderBaseService;

    @Test
    public void queryCollageOrder() {
        CollageOrderDto collageOrderDto = CollageOrderDto.builder()
                .createCollageUserId("user1")
                .partnerId("partner1")
                .storeId("store1")
                .build();
        BaseResponse<CollageOrder> response = collageOrderBaseService.queryCollageOrder(collageOrderDto);
        log.debug("queryCollageOrder return: {}", response.getResult());
    }

    @Test
    public void createCollageOrder() {
        CollageOrderDto collageOrderDto = CollageOrderDto.builder()
                .createCollageUserId("user1")
                .partnerId("partner1")
                .storeId("store1")
                .build();
        BaseResponse<CollageOrder> response = collageOrderBaseService.createCollageOrder(collageOrderDto);
        log.debug("createCollageOrder return: {}", response.getResult());
        Assert.assertNotNull(response.getResult());
    }

    @Test
    public void cancelCollageOrder() {
        CollageOrderDto collageOrderDto = CollageOrderDto.builder()
                .createCollageUserId("user1")
                .partnerId("partner1")
                .storeId("store1")
                .build();
        BaseResponse response = collageOrderBaseService.cancelCollageOrder(collageOrderDto);
        log.debug("cancelCollageOrder return: {}", response.getResult());
    }
}
