package com.freemud.sdk.api.assortment.shoppingcart.service;

import cn.freemud.base.entity.BaseResponse;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrder;
import com.freemud.sdk.api.assortment.shoppingcart.domain.CollageOrderDto;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-09-27 17:03
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public interface CollageOrderBaseService {
    /**
     * 查询拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse<CollageOrder> queryCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 创建拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse<CollageOrder> createCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 取消拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse cancelCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 锁定拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse lockCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 解锁拼单订单
     * @param collageOrderDto
     * @return
     */
    BaseResponse unlockCollageOrder(CollageOrderDto collageOrderDto);

    /**
     * 获取拼单订单锁状态
     * @param collageOrderDto
     * @return
     */
    BaseResponse<Boolean> isLockedCollageOrder(CollageOrderDto collageOrderDto);
}
