package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: GroupOrderUpdateReq
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/316:38
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class GroupOrderUpdateReq {
    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 下单渠道 1:自营微信小程序 2:i点餐 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS 16:百度外卖 18:i拼团
     */
    private Integer orderClient;

    //实际支付现金金额，扣除支付自生优惠，单位分
    private Long actualPayAmount;

    //是否需要开发票
    private boolean needInvoice;

    //订单备注
    private String note;

    //订单编号
    private String orderCode;

    //三方订单号
    private String thirdOrderCode;

    //订单原始金额，单位分
    private Long originalAmount;

    //支付渠道
    private String payChannel;

    //支付渠道名称
    private String payChannelName;

    //当前支付请求号
    private String payRequestNo;

    //支付时间
    private String payTime;

    //支付类型 1:线上支付 2:线下支付
    private Integer payType;

    //pos编号
    private String posCode;

    //用户在界面上看到的支付金额
    private Long settlementAmount;

    //门店全局唯一编号
    private String storeUnifyId;

    //用户ID
    private String userId;

    //用户姓名
    private String userName;

    //就餐人数
    private Integer dinersNumber;

    //桌台号
    private String barCounter;

    //扩展字段
    private String extInfo;

    //订单商品信息
    List<OrderItemCreateReq> orderItemList;

    //操作人
    private String operator;

}
