/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
public class AddShoppingCartGoodsRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;
    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;
    /**
     * 门店Id
     */
    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;

    /**
     * 下单类型 CreateOrderType 自取和外卖
     */
    private Integer orderType;

    private String version;

    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;


    private String appType;

    private String tableNumber;

    private Integer qty;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private Integer menuType ;

}
